/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;
uniform sampler2D iChannel1;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

void main(void)
{
	vec2 q = (gl_FragCoord.xy / iResolution.xy);
    vec2 uv = q - vec2(0.5);
    
    // Create a 3D point
    float h = 0.25;
	vec3 p = vec3(uv.x, uv.y - h - 1.0, uv.y - h);
    
    // Projecting back to 2D space
    vec2 uvm7 = p.xy / p.z;
    
    // Texture scaling if you need
    float scale = 0.4;
    uvm7 *= scale;
    
    // Rotations if needed
    float a = iGlobalTime * 0.3;
    mat2 rotation = mat2(cos(a), - sin(a), sin(a), cos(a));
    uvm7 *= rotation;
    
    // Read background texture
    vec3 col = texture2D(iChannel0, uvm7).xyz;    
    
    // Add the nyan cat sprite : https://www.shadertoy.com/view/lsX3Rr
    vec2 uvNyan = (q  - vec2(0.25, 0.15)) / (vec2(0.7,0.5) - vec2(0.5, 0.15));
    uvNyan = clamp(uvNyan, 0.0, 1.0);
    float ofx = floor( mod( iGlobalTime*15.0, 6.0 ) );
	float ww = 40.0/256.0;
    uvNyan = vec2(clamp( uvNyan.x*ww + ofx*ww, 0.0, 1.0 ), 1.0-uvNyan.y);
    vec4 colNyan = texture2D( iChannel1, uvNyan );
    
    // Generate the nyan cat shadow
    vec2 uvShadow = q - vec2(0.35, 0.23);
    float an = atan(uvShadow.y, uvShadow.x);
    float r  = length(uvShadow);
    float sh = smoothstep(0.0, 0.11, r);
    
    // Combine the nyan cat, the shadow and the background
    col = mix(sh * col, colNyan.xyz, colNyan.a);
    
    // Darkness based on the horizon
    col *= abs(uv.y - h - 0.35);
    
    // Output the color
	gl_FragColor = vec4(col,1.0);
}